package ru.yandex.json.dom;

import ru.yandex.function.GenericConsumer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StringCollectors;
import ru.yandex.json.parser.StringCollectorsFactory;

public class TypesafePopValueContentHandler
    extends TypesafeValueContentHandler
{
    private final PopConsumer popConsumer;

    public TypesafePopValueContentHandler(
        final GenericConsumer<JsonObject, ? extends JsonException> consumer)
    {
        this(consumer, StringCollectorsFactory.INSTANCE.apply(-1L));
    }

    public TypesafePopValueContentHandler(
        final GenericConsumer<JsonObject, ? extends JsonException> consumer,
        final StringCollectors stringCollectors)
    {
        this(new PopConsumer(consumer), stringCollectors);
    }

    private TypesafePopValueContentHandler(
        final PopConsumer popConsumer,
        final StringCollectors stringCollectors)
    {
        super(popConsumer, stringCollectors);
        this.popConsumer = popConsumer;
    }

    @Override
    public void stackContentHandler(
        final StackContentHandler stackContentHandler)
    {
        super.stackContentHandler(stackContentHandler);
        popConsumer.stackContentHandler(stackContentHandler);
    }

    private static class PopConsumer
        implements GenericConsumer<JsonObject, JsonException>
    {
        private final GenericConsumer<JsonObject, ? extends JsonException>
            consumer;
        private StackContentHandler stackContentHandler = null;

        PopConsumer(
            final GenericConsumer<JsonObject, ? extends JsonException>
                consumer)
        {
            this.consumer = consumer;
        }

        @Override
        public void accept(final JsonObject object) throws JsonException {
            consumer.accept(object);
            stackContentHandler.pop();
        }

        public void stackContentHandler(
            final StackContentHandler stackContentHandler)
        {
            this.stackContentHandler = stackContentHandler;
        }
    }
}

