package ru.yandex.json.parser;

public class BadContentHandler implements ContentHandler {
    @Override
    public void startObject() throws JsonException {
        throw new JsonException("Unexpected '{'");
    }

    @Override
    public void endObject() throws JsonException {
        throw new JsonException("Unexpected '}'");
    }

    @Override
    public void startArray() throws JsonException {
        throw new JsonException("Unexpected '['");
    }

    @Override
    public void endArray() throws JsonException {
        throw new JsonException("Unexpected ']'");
    }

    // CSOFF: ParameterNumber
    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        StringBuilder sb = new StringBuilder("Unexpected key '");
        sb.append(buf, off, len);
        if (!eol) {
            sb.append('…');
        }
        sb.append('\'');
        throw new JsonException(new String(sb));
    }

    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        StringBuilder sb = new StringBuilder("Unexpected string value '");
        sb.append(buf, off, len);
        if (!eol) {
            sb.append('…');
        }
        sb.append('\'');
        throw new JsonException(new String(sb));
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) throws JsonException {
        throw new JsonException("Unexpected long value '" + value + '\'');
    }

    @Override
    public void value(final double value) throws JsonException {
        throw new JsonException("Unexpected double value '" + value + '\'');
    }

    @Override
    public void value(final boolean value) throws JsonException {
        throw new JsonException("Unexpected boolean value '" + value + '\'');
    }

    @Override
    public void nullValue() throws JsonException {
        throw new JsonException("Unexpected null value");
    }

    @Override
    public void endObjectEntry() throws JsonException {
        throw new JsonException("Unexpected end of object entry");
    }
}

