package ru.yandex.json.parser;

public class ChunkedStringCollector extends AbstractStringCollector {
    private final int maxChunkSize;
    private final int maxOverhead;
    private StringBuilder currentChunk;
    private int off;

    public ChunkedStringCollector(
        final int maxChunkSize,
        final int maxOverhead)
    {
        super(new StringBuilder());
        this.maxChunkSize = maxChunkSize;
        this.maxOverhead = maxOverhead;
        currentChunk = new StringBuilder(maxChunkSize);
        off = 0;
    }

    @Override
    public String appendLast(final char[] cbuf, final int off, final int len) {
        sb.append(cbuf, off, len);
        int left = maxChunkSize - currentChunk.length();
        String result;
        if (left < sb.length()) {
            if (sb.length() > maxOverhead) {
                result = sb.toString();
            } else {
                currentChunk = new StringBuilder(maxChunkSize);
                currentChunk.append(sb);
                result = new String(currentChunk);
                this.off = currentChunk.length();
            }
        } else {
            currentChunk.append(sb);
            result = new String(currentChunk).substring(this.off);
            this.off = currentChunk.length();
        }
        sb.setLength(0);
        return result;
    }
}

