package ru.yandex.json.parser;

public interface ContentHandler {
    void startObject() throws JsonException;

    void endObject() throws JsonException;

    void startArray() throws JsonException;

    void endArray() throws JsonException;

    // CSOFF: ParameterNumber
    void key(char[] buf, int off, int len, boolean eol) throws JsonException;

    void value(char[] buf, int off, int len, boolean eol) throws JsonException;
    // CSON: ParameterNumber

    void value(long value) throws JsonException;

    void value(double value) throws JsonException;

    void value(boolean value) throws JsonException;

    void nullValue() throws JsonException;

    void endObjectEntry() throws JsonException;
}

