package ru.yandex.json.parser;

public class ContiguousStringCollector extends AbstractStringCollector {
    private int off;

    public ContiguousStringCollector(final StringBuilder sb) {
        super(sb);
        off = sb.length();
    }

    @Override
    public String appendLast(final char[] cbuf, final int off, final int len) {
        sb.append(cbuf, off, len);
        String result = new String(sb).substring(this.off);
        this.off = sb.length();
        return result;
    }
}

