package ru.yandex.json.parser;

public class ExceptionHandlingContentHandler implements ContentHandler {
    private final ContentHandler contentHandler;
    private final JsonExceptionHandler exceptionHandler;

    public ExceptionHandlingContentHandler(
        final ContentHandler contentHandler,
        final JsonExceptionHandler exceptionHandler)
    {
        this.contentHandler = contentHandler;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void startObject() throws JsonException {
        try {
            contentHandler.startObject();
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void endObject() throws JsonException {
        try {
            contentHandler.endObject();
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void startArray() throws JsonException {
        try {
            contentHandler.startArray();
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void endArray() throws JsonException {
        try {
            contentHandler.endArray();
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    // CSOFF: ParameterNumber
    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        try {
            contentHandler.key(buf, off, len, eol);
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        try {
            contentHandler.value(buf, off, len, eol);
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) throws JsonException {
        try {
            contentHandler.value(value);
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void value(final double value) throws JsonException {
        try {
            contentHandler.value(value);
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void value(final boolean value) throws JsonException {
        try {
            contentHandler.value(value);
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void nullValue() throws JsonException {
        try {
            contentHandler.nullValue();
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }

    @Override
    public void endObjectEntry() throws JsonException {
        try {
            contentHandler.endObjectEntry();
        } catch (JsonException e) {
            exceptionHandler.handleException(e);
        }
    }
}

