package ru.yandex.json.parser;

public class MalformedJsonException extends JsonException {
    private static final long serialVersionUID = 0;
    private static final String POSITION = " at position ";
    private static final String STATE = " while the state is ";

    public MalformedJsonException(final int state) {
        super("Unexpected EOF while the state is " + state);
    }

    public MalformedJsonException(
        final int state,
        final int pos,
        final char c)
    {
        super("Unexpected character " + c + POSITION + pos + STATE + state);
    }

    public MalformedJsonException(
        final int state,
        final int pos,
        final int token)
    {
        super("Unexpected token " + token + POSITION + pos + STATE + state);
    }

    public MalformedJsonException(final int pos, final String message) {
        super(message + POSITION + pos);
    }

    public MalformedJsonException(final String message) {
        super(message);
    }
}

