package ru.yandex.json.parser;

import java.util.function.LongFunction;

public enum SparseKeyStringCollectorsFactory
    implements LongFunction<StringCollectors>
{
    INSTANCE;

    @Override
    public StringCollectors apply(final long expectedSize) {
        return new StringCollectors(
            new SparseStringCollector(),
            StringCollectorFactory.INSTANCE.create(expectedSize));
    }
}

