package ru.yandex.json.parser;

public class SparseStringCollector extends AbstractStringCollector {
    public SparseStringCollector() {
        this(new StringBuilder());
    }

    public SparseStringCollector(final StringBuilder sb) {
        super(sb);
    }

    @Override
    public String appendLast(final char[] cbuf, final int off, final int len) {
        if (sb.length() == 0) {
            return new String(cbuf, off, len);
        } else {
            String result = sb.append(cbuf, off, len).toString();
            sb.setLength(0);
            return result;
        }
    }
}

