package ru.yandex.json.parser;

import java.util.Arrays;

public class StackContentHandler
    implements JsonExceptionHandler, ContentHandler
{
    private static final int INITIAL_CAPACITY = 16;

    private ContentHandler[] handlers = new ContentHandler[INITIAL_CAPACITY];
    private int size;

    public StackContentHandler() {
        size = 0;
    }

    public StackContentHandler(final StackedContentHandler handler) {
        handlers[0] = handler;
        size = 1;
        handler.stackContentHandler(this);
    }

    public void push(final ContentHandler handler) {
        if (size == handlers.length) {
            handlers = Arrays.copyOf(handlers, size << 1);
        }
        handlers[size++] = handler;
    }

    public void push(final StackedContentHandler handler) {
        push((ContentHandler) handler);
        handler.stackContentHandler(this);
    }

    public void pop() {
        --size;
    }

    @Override
    public void handleException(final JsonException e) throws JsonException {
        e.addSuppressed(
            new Exception(
                "Exception occured at "
                + Arrays.toString(Arrays.copyOf(handlers, size))));
        throw e;
    }

    @Override
    public void startObject() throws JsonException {
        handlers[size - 1].startObject();
    }

    @Override
    public void endObject() throws JsonException {
        handlers[size - 1].endObject();
    }

    @Override
    public void startArray() throws JsonException {
        handlers[size - 1].startArray();
    }

    @Override
    public void endArray() throws JsonException {
        handlers[size - 1].endArray();
    }

    // CSOFF: ParameterNumber
    @Override
    public void key(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        handlers[size - 1].key(buf, off, len, eol);
    }

    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        handlers[size - 1].value(buf, off, len, eol);
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) throws JsonException {
        handlers[size - 1].value(value);
    }

    @Override
    public void value(final double value) throws JsonException {
        handlers[size - 1].value(value);
    }

    @Override
    public void value(final boolean value) throws JsonException {
        handlers[size - 1].value(value);
    }

    @Override
    public void nullValue() throws JsonException {
        handlers[size - 1].nullValue();
    }

    @Override
    public void endObjectEntry() throws JsonException {
        handlers[size - 1].endObjectEntry();
    }
}

