package ru.yandex.json.parser;

import java.util.function.LongFunction;

public enum StringCollectorsFactory implements LongFunction<StringCollectors> {
    INSTANCE;

    @Override
    public StringCollectors apply(final long expectedSize) {
        StringCollector collector =
            StringCollectorFactory.INSTANCE.create(expectedSize);
        return new StringCollectors(collector, collector);
    }
}

