package ru.yandex.json.rpc;

import java.io.IOException;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class JsonRpcException
    extends Exception
    implements JsonRpcFields, JsonValue
{
    private static final long serialVersionUID = 0L;

    private final JsonRpcErrorCode code;
    private final String message;
    private final JsonObject data;

    public JsonRpcException(
        final JsonRpcErrorCode code,
        final String message)
    {
        this(code, message, null, null);
    }

    public JsonRpcException(
        final JsonRpcErrorCode code,
        final String message,
        final JsonObject data)
    {
        this(code, message, data, null);
    }

    public JsonRpcException(
        final JsonRpcErrorCode code,
        final String message,
        final Throwable cause)
    {
        this(code, message, (JsonObject) null, cause);
    }

    public JsonRpcException(
        final JsonRpcErrorCode code,
        final String message,
        final JsonObject data,
        final Throwable cause)
    {
        this.code = code;
        this.message = message;
        this.data = data;
        if (cause != null) {
            initCause(cause);
        }
    }

    public JsonRpcErrorCode code() {
        return code;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        getMessage(sb);
        return new String(sb);
    }

    public void getMessage(final StringBuilder sb) {
        sb.append(code.value());
        sb.append(' ');
        sb.append(code.description());
        sb.append(':');
        sb.append(' ');
        sb.append(message);
    }

    public JsonObject data() {
        return data;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key(CODE);
        writer.value(code.value());
        writer.key(MESSAGE);
        writer.value(message);
        Throwable cause = getCause();
        if (data != null || cause != null) {
            writer.key(DATA);
            writer.startObject();
            if (data != null) {
                writer.key(CONTEXT);
                data.writeValue(writer);
            }
            if (cause != null) {
                writer.key(CAUSE);
                writer.value(cause);
            }
            writer.endObject();
        }
        writer.endObject();
    }
}

