package ru.yandex.json.rpc;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.string.NonEmptyValidator;

public class JsonRpcRequest implements JsonRpcFields {
    private final String version;
    private final long id;
    private final String method;
    private final JsonObject params;

    public JsonRpcRequest(final JsonObject request) throws JsonException {
        JsonMap map = request.asMap();
        version = map.getString(JSONRPC);
        if (!version.startsWith("2.")) {
            throw new JsonException(
                "JSON RPC version is not supported: " + version);
        }
        id = map.getLong(ID);
        method = map.get(METHOD, NonEmptyValidator.INSTANCE);
        params = map.get(PARAMS);
    }

    public String version() {
        return version;
    }

    public long id() {
        return id;
    }

    public String method() {
        return method;
    }

    public JsonObject params() {
        return params;
    }
}

