package ru.yandex.json.rpc;

import java.io.IOException;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class JsonRpcResponse implements JsonRpcFields, JsonValue {
    private final JsonRpcRequest request;
    private final JsonObject result;
    private final JsonRpcException error;

    public JsonRpcResponse(
        final JsonRpcRequest request,
        final JsonObject result)
    {
        this.request = request;
        this.result = result;
        error = null;
    }

    public JsonRpcResponse(
        final JsonRpcRequest request,
        final JsonRpcException error)
    {
        this.request = request;
        this.error = error;
        result = null;
    }

    public JsonObject result() {
        return result;
    }

    public JsonRpcException error() {
        return error;
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key(JSONRPC);
        if (request == null) {
            writer.value("2.0");
            writer.key(ID);
            writer.nullValue();
        } else {
            writer.value(request.version());
            writer.key(ID);
            writer.value(request.id());
        }
        if (result != null) {
            writer.key(RESULT);
            result.writeValue(writer);
        }
        if (error != null) {
            writer.key(ERROR);
            error.writeValue(writer);
        }
        writer.endObject();
    }
}

