package ru.yandex.json.writer;

import java.io.IOException;
import java.io.Writer;

public class CompatibilityJsonWriter extends JsonWriter {
    public CompatibilityJsonWriter(final Writer writer) {
        super(writer);
    }

    @Override
    protected void writeImpl(int c) throws IOException {
        if (c >= 128 || c == '"' || c < ' ') {
            writer.write(String.format("\\u%04x", c));
        } else {
            writer.write(c);
        }
    }

    @Override
    protected void writeImpl(final char[] cbuf, int off, final int len)
        throws IOException
    {
        for (int i = 0; i < len; ++i) {
            writeImpl(cbuf[i + off]);
        }
    }
}

