package ru.yandex.json.writer;

import java.io.IOException;
import java.io.Writer;

public class DollarJsonWriter extends JsonWriter {
    public DollarJsonWriter(final Writer writer) {
        super(writer);
    }

    @Override
    protected void writeStartString() throws IOException {
        writer.write('$');
    }

    @Override
    protected void writeEndString() throws IOException {
        writer.write('\000');
    }

    @Override
    protected void writeImpl(final int c) throws IOException {
        if (c == '\000') {
            writer.write('\000');
        }
        writer.write(c);
    }

    // CSOFF: FinalParameters
    @Override
    protected void writeImpl(final char[] cbuf, int off, final int len)
        throws IOException
    {
        int pos = off;
        for (int i = 0; i < len; ++i, ++pos) {
            if (cbuf[pos] == '\000') {
                int length = pos - off;
                switch (length) {
                    case 0:
                        break;
                    case 1:
                        writer.write(cbuf[off]);
                        break;
                    default:
                        writer.write(cbuf, off, length);
                        break;
                }
                writer.write('\000');
                writer.write('\000');
                off = pos + 1;
            }
        }
        writer.write(cbuf, off, pos - off);
    }
    // CSON: FinalParameters
}

