package ru.yandex.json.writer;

import java.io.IOException;
import java.io.OutputStream;

public class DollarUtf8JsonWriter extends Utf8JsonWriter {
    public DollarUtf8JsonWriter(final OutputStream writer) {
        super(writer);
    }

    @Override
    protected void writeStartString() throws IOException {
        out.write('$');
    }

    @Override
    protected void writeEndString() throws IOException {
        out.write('\000');
    }

    @Override
    protected void writeImpl(final int c) throws IOException {
        if (c == '\000') {
            out.write('\000');
        }
        out.write(c);
    }

    @Override
    protected void writeImpl(final char[] cbuf, int off, final int len)
        throws IOException
    {
        int pos = off;
        for (int i = 0; i < len; ++i, ++pos) {
            if (cbuf[pos] == '\000') {
                int length = pos - off;
                switch (length) {
                    case 0:
                        break;
                    case 1:
                        out.write(cbuf[off]);
                        break;
                    default:
                        writeChars(cbuf, off, length);
                        break;
                }
                out.write('\000');
                out.write('\000');
                off = pos + 1;
            }
        }
        writeChars(cbuf, off, pos - off);
    }

    @Override
    protected void writeImpl(final byte[] bbuf, int off, final int len)
        throws IOException
    {
        int pos = off;
        for (int i = 0; i < len; ++i, ++pos) {
            if (bbuf[pos] == '\000') {
                int length = pos - off;
                switch (length) {
                    case 0:
                        break;
                    case 1:
                        out.write(bbuf[off]);
                        break;
                    default:
                        out.write(bbuf, off, length);
                        break;
                }
                out.write('\000');
                out.write('\000');
                off = pos + 1;
            }
        }
        out.write(bbuf, off, pos - off);
    }
}

