package ru.yandex.json.writer;

import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.ValuesStorage;

public class JsonTypeExtractor {
    public static final JsonTypeExtractor NULL =
        new JsonTypeExtractor(null);
    public static final JsonTypeExtractor NORMAL =
        new JsonTypeExtractor(JsonType.NORMAL);
    public static final JsonTypeExtractor DOLLAR =
        new JsonTypeExtractor(JsonType.DOLLAR);
    public static final JsonTypeExtractor HUMAN_READABLE =
        new JsonTypeExtractor(JsonType.HUMAN_READABLE);
    public static final JsonTypeExtractor COMPATIBILITY =
        new JsonTypeExtractor(JsonType.COMPATIBILITY);

    private final JsonType defaultJsonType;

    protected JsonTypeExtractor(final JsonType defaultJsonType) {
        this.defaultJsonType = defaultJsonType;
    }

    public JsonType extract(final String jsonTypeString, final boolean hr) {
        JsonType jsonType;
        if (jsonTypeString == null) {
            if (hr) {
                jsonType = JsonType.HUMAN_READABLE;
            } else {
                jsonType = defaultJsonType;
            }
        } else {
            jsonType =
                new EnumParser<JsonType>(JsonType.class).apply(jsonTypeString);
        }
        return jsonType;
    }
    // CSON: RedundantThrows

    // CSOFF: RedundantThrows
    public <E extends Exception> JsonType extract(
        final ValuesStorage<E> storage)
        throws E
    {
        JsonType jsonType = storage.getEnum(JsonType.class, "json-type", null);
        if (jsonType == null) {
            if (storage.getBoolean("hr", false)) {
                jsonType = JsonType.HUMAN_READABLE;
            } else {
                jsonType = defaultJsonType;
            }
        }
        return jsonType;
    }
    // CSON: RedundantThrows
}

