package ru.yandex.json.xpath;

import java.util.List;

public class CompositeHandlerResolver<T> implements HandlerResolver<T> {
    private final List<HandlerResolver<T>> resolvers;

    public CompositeHandlerResolver(final List<HandlerResolver<T>> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public T lookup(final List<PathComponent> path) {
        for (HandlerResolver<T> resolver: resolvers) {
            T handler = resolver.lookup(path);
            if (handler != null) {
                return handler;
            }
        }
        return null;
    }
}

