package ru.yandex.json.xpath;

import java.util.List;

import ru.yandex.json.parser.JsonException;

public class CompositePrimitiveHandler implements PrimitiveHandler {
    private final PrimitiveHandler defaultHandler;
    private final List<? extends HandlerResolver<? extends PrimitiveHandler>>
        resolvers;
    private final int size;

    public CompositePrimitiveHandler(
        final List<? extends HandlerResolver<? extends PrimitiveHandler>>
        resolvers)
    {
        this(IgnoringPrimitiveHandler.INSTANCE, resolvers);
    }

    public CompositePrimitiveHandler(
        final PrimitiveHandler defaultHandler,
        final List<? extends HandlerResolver<? extends PrimitiveHandler>>
        resolvers)
    {
        this.defaultHandler = defaultHandler;
        this.resolvers = resolvers;
        size = resolvers.size();
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonException
    {
        for (int i = 0; i < size; ++i) {
            PrimitiveHandler handler = resolvers.get(i).lookup(path);
            if (handler != null) {
                handler.handle(path, value);
                return;
            }
        }
        defaultHandler.handle(path, value);
    }
}

