package ru.yandex.json.xpath;

import ru.yandex.json.parser.JsonException;

public class JsonUnexpectedTokenException extends JsonException {
    private static final long serialVersionUID = 0;

    public JsonUnexpectedTokenException(final Object token) {
        super(message(token));
    }

    public JsonUnexpectedTokenException(
        final Object token,
        final Throwable cause)
    {
        super(message(token), cause);
    }

    private static String message(final Object token) {
        if (token == null) {
            return "Unexpected null token";
        } else {
            return "Unexpected token '" + token
                + "' of type " + token.getClass().getName();
        }
    }
}

