package ru.yandex.json.xpath;

import java.util.List;

public class ListComponentMatcher implements PathMatcher {
    private final ComponentMatcher[] matchers;

    public ListComponentMatcher(final ComponentMatcher... matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean matches(final List<PathComponent> path) {
        int size = path.size();
        boolean matches = size == matchers.length;
        for (int i = 0; matches && i < size; ++i) {
            matches = matchers[i].matches(path.get(i));
        }
        return matches;
    }
}

