package ru.yandex.json.xpath;

import java.util.List;

public class ListHandlerResolver<T>
    extends ListComponentMatcher
    implements HandlerResolver<T>
{
    private final T handler;

    public ListHandlerResolver(
        final T handler,
        final ComponentMatcher... matchers)
    {
        super(matchers);
        this.handler = handler;
    }

    @Override
    public T lookup(final List<PathComponent> path) {
        if (matches(path)) {
            return handler;
        }
        return null;
    }
}

