package ru.yandex.json.xpath;

public class PathComponent {
    private String name;
    private int index;

    public PathComponent(final String name) {
        this.name = name;
        index = 0;
    }

    public PathComponent(final int index) {
        this.index = index;
        name = null;
    }

    public String name() {
        return name;
    }

    void name(final String name) {
        this.name = name;
    }

    public int index() {
        return index;
    }

    void increment() {
        ++index;
    }

    @Override
    public String toString() {
        if (name == null) {
            return new String(
                new StringBuilder().append('[').append(index).append(']'));
        } else {
            return name;
        }
    }
}

