package ru.yandex.json.xpath;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.parser.xpath.BadXPathException;
import ru.yandex.parser.xpath.PathConsumer;

public class XPathConsumer implements PathConsumer<BadXPathException> {
    private final List<ComponentMatcher> matchers = new ArrayList<>();

    public PathMatcher matcher() {
        int size = matchers.size();
        if (size == 1) {
            return matchers.get(0);
        } else {
            return new ListComponentMatcher(
                matchers.toArray(new ComponentMatcher[size]));
        }
    }

    @Override
    public BadXPathException parseFailedException(final String message) {
        return new BadXPathException(message);
    }

    @Override
    public BadXPathException parseFailedException(
        final String message,
        final Throwable cause)
    {
        return new BadXPathException(message, cause);
    }

    @Override
    public void name(final String name) {
        if (name.length() == 1 && name.charAt(0) == '*') {
            matchers.add(AnyNameMatcher.INSTANCE);
        } else {
            matchers.add(new NameMatcher(name));
        }
    }

    @Override
    public void index(final int index) {
        matchers.add(new IndexMatcher(index));
    }

    @Override
    public void anyIndex() {
        matchers.add(AnyIndexMatcher.INSTANCE);
    }

}

