package ru.yandex.json.xpath;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollector;
import ru.yandex.json.parser.StringCollectors;
import ru.yandex.json.parser.StringCollectorsFactory;

public class XPathContentHandler extends XPathContentHandlerBase {
    private final PrimitiveHandler handler;
    private final StringCollector valueStringCollector;

    public XPathContentHandler(final PrimitiveHandler handler) {
        this(handler, StringCollectorsFactory.INSTANCE.apply(-1L));
    }

    public XPathContentHandler(
        final PrimitiveHandler handler,
        final StringCollectors stringCollectors)
    {
        super(stringCollectors.keyStringCollector());
        this.handler = handler;
        valueStringCollector = stringCollectors.valueStringCollector();
    }

    private void value(final Object value) throws JsonException {
        handler.handle(this, value);
        afterValue();
    }

    // CSOFF: ParameterNumber
    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        if (eol) {
            value(valueStringCollector.appendLast(buf, off, len));
        } else {
            valueStringCollector.append(buf, off, len);
        }
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) throws JsonException {
        value(Long.valueOf(value));
    }

    @Override
    public void value(final double value) throws JsonException {
        value(Double.valueOf(value));
    }

    @Override
    public void value(final boolean value) throws JsonException {
        value(Boolean.valueOf(value));
    }

    @Override
    public void nullValue() throws JsonException {
        value(null);
    }
}

