package ru.yandex.json.xpath;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StringCollector;

public class XPathStackContentHandler extends XPathContentHandlerBase {
    private final HandlerResolver<? extends ContentHandler> resolver;
    private final StackContentHandler stackHandler;

    public XPathStackContentHandler(
        final HandlerResolver<? extends ContentHandler> resolver,
        final StackContentHandler stackHandler,
        final StringCollector keyStringCollector)
    {
        super(keyStringCollector);
        this.resolver = resolver;
        this.stackHandler = stackHandler;
    }

    private boolean pathChanged() {
        ContentHandler handler = resolver.lookup(this);
        if (handler == null) {
            return false;
        } else {
            stackHandler.push(handler);
            return true;
        }
    }

    @Override
    public void startArray() throws JsonException {
        if (pathChanged()) {
            stackHandler.startArray();
        } else {
            super.startArray();
        }
    }

    @Override
    public void startObject() throws JsonException {
        if (pathChanged()) {
            stackHandler.startObject();
        } else {
            super.startObject();
        }
    }

    // CSOFF: ParameterNumber
    @Override
    public void value(
        final char[] buf,
        final int off,
        final int len,
        final boolean eol)
        throws JsonException
    {
        if (pathChanged()) {
            stackHandler.value(buf, off, len, eol);
        } else if (eol) {
            // Path didn't matched any handler, so value is ignored
            // Just make sure, that path change is accounted
            afterValue();
        }
    }
    // CSON: ParameterNumber

    @Override
    public void value(final long value) throws JsonException {
        if (pathChanged()) {
            stackHandler.value(value);
        }
        afterValue();
    }

    @Override
    public void value(final double value) throws JsonException {
        if (pathChanged()) {
            stackHandler.value(value);
        }
        afterValue();
    }

    @Override
    public void value(final boolean value) throws JsonException {
        if (pathChanged()) {
            stackHandler.value(value);
        }
        afterValue();
    }

    @Override
    public void nullValue() throws JsonException {
        if (pathChanged()) {
            stackHandler.nullValue();
        }
        afterValue();
    }
}

