package ru.yandex.lemmer;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Lemmer {
    static {
        System.loadLibrary("lemmer-ng");
    }

    private Lemmer() {
    }

    public static String[] analyzeWord(final char[] buf) {
        return analyzeWord(buf, buf.length);
    }

    public static native String[] analyzeWord(final char[] buf, final int len);

    public static void main(final String... args) throws Exception {
        try (BufferedReader reader =
                new BufferedReader(
                    new InputStreamReader(
                        System.in,
                        StandardCharsets.UTF_8)))
        {
            reader.lines().forEach(
                line -> System.out.println(
                    Arrays.toString(analyzeWord(line.toCharArray()))));
        }
    }
}
