package ru.yandex.cache.lmdb;

import ru.yandex.cache.CacheEntry;

public final class LMDBCacheEntry extends CacheEntry {
    private final long address;

    public LMDBCacheEntry(
        final int compressedSize,
        final int decompressedSize,
        final long address)
    {
        super(compressedSize, decompressedSize);
        this.address = address;
    }

    @Override
    public long address() {
        return address;
    }

    @Override
    public void close() {
        if (address != 0) {
            LMDBCache.freeBlob(address);
        }
    }
}
