package ru.yandex.mail.search.logbroker.logger;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.json.writer.Utf8JsonWriter;

public class LogbrokerJsonLogger implements GenericAutoCloseable<IOException> {
    private final LogbrokerLogger logger;
    private final ThreadLocal<LogbrokerJsonWriter> writerTl;

    public LogbrokerJsonLogger(final LogbrokerLogger logger) {
        this.logger = logger;
        this.writerTl = new ThreadLocal<>();
    }

    public void start() {
        logger.start();
    }

    /**
     * Do not share writers among threads, fetch it when you are ready to write
     * Call flush when record is ready
     * @return json writer
     */
    public JsonWriterBase writer() {
        LogbrokerJsonWriter writer = writerTl.get();
        if (writer == null) {
            writer = new LogbrokerJsonWriter(new ByteArrayOutputStream());
            writerTl.set(writer);
        }

        return writer;
    }

    private final class LogbrokerJsonWriter
        extends Utf8JsonWriter
    {
        private final ByteArrayOutputStream bos;

        private LogbrokerJsonWriter(final ByteArrayOutputStream out) {
            super(out);

            this.bos = out;
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            byte[] data = bos.toByteArray();
            logger.write(data);
            bos.reset();
            reset();
        }
    }

    @Override
    public void close() throws IOException {
        logger.close();
    }
}
