package ru.yandex.mail.search.logbroker.logger;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import org.apache.http.HttpException;

import ru.yandex.client.tvm2.Tvm2ServiceContextRenewalTask;
import ru.yandex.client.tvm2.Tvm2TicketRenewalTask;
import ru.yandex.http.util.server.AbstractHttpServer;
import ru.yandex.json.parser.JsonException;
import ru.yandex.kikimr.persqueue.auth.Credentials;
import ru.yandex.kikimr.persqueue.producer.transport.message.inbound.ProducerWriteResponse;
import ru.yandex.mail.search.logbroker.logger.config.ImmutableLogbrokerLoggerConfig;

public class Tvm2LogbrokerLogger implements LogbrokerLogger {
    private final Tvm2TicketRenewalTask task;
    private final LogbrokerLogger logbrokerLogger;

    public Tvm2LogbrokerLogger(
        final AbstractHttpServer<?, ?> server,
        final Tvm2ServiceContextRenewalTask tvm2ServiceContext,
        final ImmutableLogbrokerLoggerConfig config)
        throws IOException
    {
        try {
            task =
                new Tvm2TicketRenewalTask(
                    server.logger(),
                    tvm2ServiceContext,
                    config);
        } catch (HttpException
            | IOException
            | JsonException
            | URISyntaxException e)
        {
            throw new IOException(e);
        }

        logbrokerLogger =
            new BasicLogbrokerLogger(
                server,
                new Tvm2CredentialSupplier(),
                config);
    }

    @Override
    public void start() {
        task.start();
    }

    @Override
    public CompletableFuture<ProducerWriteResponse> write(
        final byte[] data)
    {
        return logbrokerLogger.write(data);
    }

    @Override
    public void close() throws IOException {
        logbrokerLogger.close();

        task.cancel();
    }

    private final class Tvm2CredentialSupplier
        implements Supplier<Credentials>
    {
        private Tvm2CredentialSupplier() {
        }

        @Override
        public Credentials get() {
            return Credentials.tvm(task.ticket());
        }
    }
}
