package ru.yandex.mail.search.logbroker.logger.config;

import org.apache.http.HttpHost;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLogbrokerLoggerConfig
    extends ImmutableTvm2ClientConfig
    implements LogbrokerLoggerConfig
{
    private final String topic;
    private final HttpHost logbrokerHost;

    public ImmutableLogbrokerLoggerConfig(
        final LogbrokerLoggerConfig config)
        throws ConfigException
    {
        super(config);

        this.topic = config.topic();
        this.logbrokerHost = config.logbrokerHost();
    }

    @Override
    public String topic() {
        return topic;
    }

    @Override
    public HttpHost logbrokerHost() {
        return logbrokerHost;
    }
}
