package ru.yandex.mail.search.logbroker.logger.config;

import org.apache.http.HttpHost;

import ru.yandex.client.tvm2.AbstractTvm2ClientConfigBuilder;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class LogbrokerLoggerConfigBuilder
    extends AbstractTvm2ClientConfigBuilder<LogbrokerLoggerConfigBuilder>
    implements LogbrokerLoggerConfig
{
    private String topic;
    private HttpHost logbrokerHost;

    public LogbrokerLoggerConfigBuilder() {
        this(LogbrokerLoggerConfigDefaults.INSTANCE);
    }

    public LogbrokerLoggerConfigBuilder(final LogbrokerLoggerConfig config) {
        super(config);

        this.logbrokerHost(config.logbrokerHost());
        this.topic(config.topic());
    }

    public LogbrokerLoggerConfigBuilder(
        final IniConfig config,
        final LogbrokerLoggerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        this.topic = config.getString("topic", defaults.topic());
        this.logbrokerHost =
            config.get(
                "balancer",
                defaults.logbrokerHost(),
                HttpHostParser.INSTANCE);
    }

    @Override
    public String topic() {
        return topic;
    }

    public LogbrokerLoggerConfigBuilder topic(final String topic) {
        this.topic = topic;
        return this;
    }

    @Override
    public HttpHost logbrokerHost() {
        return logbrokerHost;
    }

    public LogbrokerLoggerConfigBuilder logbrokerHost(
        final HttpHost logbrokerHost)
    {
        this.logbrokerHost = logbrokerHost;
        return this;
    }

    @Override
    public LogbrokerLoggerConfigBuilder self() {
        return this;
    }
}
