package ru.yandex.logbroker2;

import java.util.Map;

import ru.yandex.logbroker2.config.ImmutableFieldConfig;
import ru.yandex.parser.config.ConfigException;

public enum LBDataFormat {
    RAW {
        @Override
        public DataProcessor createDataProcessor(
            final Map<String, ImmutableFieldConfig> fields)
            throws ConfigException
        {
            throw new ConfigException("Raw data parsing is not supported");
        }
    },
    TSKV {
        @Override
        public DataProcessor createDataProcessor(
            final Map<String, ImmutableFieldConfig> fields)
            throws ConfigException
        {
            throw new ConfigException("TSKV data parsing is not implemented");
        }
    },
    JSON {
        @Override
        public DataProcessor createDataProcessor(
            final Map<String, ImmutableFieldConfig> fields)
            throws ConfigException
        {
            return new JsonDataProcessor(fields);
        }
    };

    public abstract DataProcessor createDataProcessor(
        Map<String, ImmutableFieldConfig> fields)
        throws ConfigException;
}

