package ru.yandex.logbroker2;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.kikimr.persqueue.consumer.StreamListener.ReadResponder;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageData;
import ru.yandex.kikimr.persqueue.consumer.transport.message.inbound.data.MessageMeta;

public class LBMessage extends AbstractStringBuilderable {
    private final byte[] data;
    private final long offset;
    private final long createTime;
    private final long writeTime;
    private final long seqNo;
    private final ReadResponder readResponder;

    public LBMessage(
        final MessageData message,
        final ReadResponder readResponder)
    {
        this.readResponder = readResponder;

        data = message.getDecompressedData();
        offset = message.getOffset();

        MessageMeta meta = message.getMessageMeta();

        createTime = meta.getCreateTimeMs();
        writeTime = meta.getWriteTimeMs();
        seqNo = meta.getSeqNo();
    }

    public byte[] data() {
        return data;
    }

    public long offset() {
        return offset;
    }

    public long seqNo() {
        return seqNo;
    }

    public long createTime() {
        return createTime;
    }

    public long writeTime() {
        return writeTime;
    }

    public ReadResponder readResponder() {
        return readResponder;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append("LBMessage: seqNo=");
        sb.append(seqNo);
        sb.append(", offset=");
        sb.append(offset);
        sb.append(", dataLen=");
        sb.append(data.length);
        sb.append(", createTime=");
        sb.append(createTime);
        sb.append(", writeTime=");
        sb.append(writeTime);
    }
}
