package ru.yandex.logbroker2;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.json.parser.JsonException;
import ru.yandex.logbroker2.config.ImmutableLogbroker2ConsumerConfig;
import ru.yandex.logbroker2.config.ImmutableLogbroker2SingleConsumerConfig;
import ru.yandex.parser.config.ConfigException;

public class Logbroker2Consumer
    extends HttpProxy<ImmutableLogbroker2ConsumerConfig>
{
    private final List<Logbroker2SingleConsumer> consumers;

    public Logbroker2Consumer(final ImmutableLogbroker2ConsumerConfig config)
        throws ConfigException,
            HttpException,
            IOException,
            JsonException,
            URISyntaxException
    {
        super(config);
        consumers = new ArrayList<>(config.consumers().size());
        for (Map.Entry<String, ImmutableLogbroker2SingleConsumerConfig> entry
            : config.consumers().entrySet())
        {
            String name = entry.getKey();
            ImmutableLogbroker2SingleConsumerConfig consumerConfig =
                entry.getValue();
            String tvmClientId = consumerConfig.tvmClientId();
            if (tvmClientId != null) {
                tvm2ClientTicketGenerator.addDestId(tvmClientId);
            }
            Logbroker2SingleConsumer consumer =
                new Logbroker2SingleConsumer(
                    this,
                    consumerConfig,
                    logger.addPrefix(name),
                    name,
                    tvm2ClientTicketGenerator);
            closeChain.add(consumer);
            consumers.add(consumer);
            registerStater(consumer);
        }
    }

    @Override
    public void start() throws IOException {
        super.start();
        for (Logbroker2SingleConsumer consumer: consumers) {
            consumer.start();
        }
    }
}
