package ru.yandex.logbroker2.config;

import ru.yandex.logbroker2.FieldDuplicationPolicy;
import ru.yandex.logbroker2.FieldPresencePolicy;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFieldConfigBuilder
    <T extends AbstractFieldConfigBuilder<T>>
    implements ConfigBuilder<T>, FieldConfig
{
    private String selector;
    private FieldPresencePolicy presence;
    private String headerName;
    private String cgiParameter;
    private FieldDuplicationPolicy onDuplicate;

    protected AbstractFieldConfigBuilder(final FieldConfig config) {
        selector(config.selector());
        presence(config.presence());
        headerName(config.headerName());
        cgiParameter(config.cgiParameter());
        onDuplicate(config.onDuplicate());
    }

    protected AbstractFieldConfigBuilder(
        final IniConfig config,
        final FieldConfig defaults)
        throws ConfigException
    {
        selector = SELECTOR.extract(config, defaults.selector());
        presence = PRESENCE.extract(config, defaults.presence());
        headerName = HEADER_NAME.extract(config, defaults.headerName());
        cgiParameter = CGI_PARAMETER.extract(config, defaults.cgiParameter());
        onDuplicate = ON_DUPLICATE.extract(config, defaults.onDuplicate());
    }

    @Override
    public String selector() {
        return selector;
    }

    public T selector(final String selector) {
        this.selector = selector;
        return self();
    }

    @Override
    public FieldPresencePolicy presence() {
        return presence;
    }

    public T presence(final FieldPresencePolicy presence) {
        this.presence = presence;
        return self();
    }

    @Override
    public String headerName() {
        return headerName;
    }

    public T headerName(final String headerName) {
        this.headerName = headerName;
        return self();
    }

    @Override
    public String cgiParameter() {
        return cgiParameter;
    }

    public T cgiParameter(final String cgiParameter) {
        this.cgiParameter = cgiParameter;
        return self();
    }

    @Override
    public FieldDuplicationPolicy onDuplicate() {
        return onDuplicate;
    }

    public T onDuplicate(final FieldDuplicationPolicy onDuplicate) {
        this.onDuplicate = onDuplicate;
        return self();
    }
}

