package ru.yandex.logbroker2.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ClientHttpsConfig;
import ru.yandex.http.config.ClientHttpsConfigBuilder;
import ru.yandex.http.config.RetriesConfig;
import ru.yandex.http.config.RetriesConfigBuilder;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractGrpcHostConfigBuilder
    <T extends AbstractGrpcHostConfigBuilder<T>>
     implements GrpcHostConfig
{
    private HttpHost host;
    private ClientHttpsConfigBuilder https;
    private RetriesConfigBuilder retries;
    private String userAgent;
    private long keepAliveTimeout;
    private long keepAliveTime;
    private boolean keepAliveWithoutCalls;

    protected AbstractGrpcHostConfigBuilder(final GrpcHostConfig config) {
        host(config.host());
        https(config.https());
        retries(config.retries());
        userAgent(config.userAgent());
        keepAliveTimeout(config.keepAliveTimeout());
        keepAliveTime(config.keepAliveTime());
        keepAliveWithoutCalls(config.keepAliveWithoutCalls());
    }

    protected AbstractGrpcHostConfigBuilder(
        final IniConfig config,
        final GrpcHostConfig defaults)
        throws ConfigException
    {
        this.host = config.get("host", defaults.host(), HttpHostParser.INSTANCE);
        this.https =
            new ClientHttpsConfigBuilder(
                config.section("https"),
                defaults.https());
        this.retries =
            new RetriesConfigBuilder(
                config.section("retries"),
                defaults.retries());
        this.userAgent = config.getString("user-agent", defaults.userAgent());
        this.keepAliveTimeout =
            config.getLong("keep-alive-timeout", defaults.keepAliveTimeout());
        this.keepAliveTime =
            config.getLong("keep-alive-time", defaults.keepAliveTime());
        this.keepAliveWithoutCalls =
            config.getBoolean(
                "keep-alive-without-calls",
                defaults.keepAliveWithoutCalls());
    }

    @Override()
    public HttpHost host() {
        return host;
    }

    public T host(final HttpHost value) {
        this.host = value;
        return self();
    }

    @Override()
    public ClientHttpsConfigBuilder https() {
        return https;
    }

    public T https(final ClientHttpsConfig value) {
        this.https = new ClientHttpsConfigBuilder(
            value);
        return self();
    }

    @Override()
    public RetriesConfigBuilder retries() {
        return retries;
    }

    public T retries(final RetriesConfig value) {
        this.retries = new RetriesConfigBuilder(
            value);
        return self();
    }

    @Override()
    public String userAgent() {
        return userAgent;
    }

    public T userAgent(final String value) {
        this.userAgent = value;
        return self();
    }

    @Override()
    public long keepAliveTimeout() {
        return keepAliveTimeout;
    }

    public T keepAliveTimeout(final long value) {
        this.keepAliveTimeout = value;
        return self();
    }

    @Override()
    public long keepAliveTime() {
        return keepAliveTime;
    }

    public T keepAliveTime(final long value) {
        this.keepAliveTime = value;
        return self();
    }

    @Override()
    public boolean keepAliveWithoutCalls() {
        return keepAliveWithoutCalls;
    }

    public T keepAliveWithoutCalls(final boolean value) {
        this.keepAliveWithoutCalls = value;
        return self();
    }

    protected abstract T self();
}
