package ru.yandex.logbroker2.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractLogbroker2ConsumerConfigBuilder
    <T extends AbstractLogbroker2ConsumerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements Logbroker2ConsumerConfig
{
    private Map<String, Logbroker2SingleConsumerConfigBuilder> consumers;

    protected AbstractLogbroker2ConsumerConfigBuilder(
        final Logbroker2ConsumerConfig config)
    {
        super(config);
        consumers(config.consumers());
    }

    protected AbstractLogbroker2ConsumerConfigBuilder(
        final IniConfig config,
        final Logbroker2ConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig consumerSection = config.sectionOrNull("consumer");
        if (consumerSection == null) {
            consumers = new LinkedHashMap<>(2);
            consumers.put(
                "default",
                new Logbroker2SingleConsumerConfigBuilder(config));
        } else {
            Set<String> names = consumerSection.sections().keySet();
            consumers = new LinkedHashMap<>(names.size() << 1);
            for (String name: names) {
                consumers.put(
                    name,
                    new Logbroker2SingleConsumerConfigBuilder(
                        consumerSection.section(name)));
            }
        }
    }

    @Override
    public Map<String, Logbroker2SingleConsumerConfigBuilder> consumers() {
        return consumers;
    }

    public T consumers(
        final Map<String, ? extends Logbroker2SingleConsumerConfig> consumers)
    {
        this.consumers = new LinkedHashMap<>(consumers.size());
        for (Map.Entry<String, ? extends Logbroker2SingleConsumerConfig> entry
            : consumers.entrySet())
        {
            this.consumers.put(
                entry.getKey(),
                new Logbroker2SingleConsumerConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

