package ru.yandex.logbroker2.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.logbroker2.FieldDuplicationPolicy;
import ru.yandex.logbroker2.FieldPresencePolicy;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface FieldConfig {
    ParameterConfig<String> SELECTOR =
        new ParameterConfig<>(
            "selector",
            GenericFunction.identity(),
            NonEmptyValidator.INSTANCE);

    ParameterConfig<FieldPresencePolicy> PRESENCE =
        new ParameterConfig<>(
            "presence",
            new EnumParser<>(FieldPresencePolicy.class),
            GenericFunction.identity());

    ParameterConfig<String> HEADER_NAME =
        new ParameterConfig<>(
            "header-name",
            GenericFunction.identity(),
            GenericFunction.identity(),
            true);

    ParameterConfig<String> CGI_PARAMETER =
        new ParameterConfig<>(
            "cgi-parameter",
            GenericFunction.identity(),
            GenericFunction.identity(),
            true);

    ParameterConfig<FieldDuplicationPolicy> ON_DUPLICATE =
        new ParameterConfig<>(
            "on-duplicate",
            new EnumParser<>(FieldDuplicationPolicy.class),
            GenericFunction.identity());

    String selector();

    FieldPresencePolicy presence();

    String headerName();

    String cgiParameter();

    FieldDuplicationPolicy onDuplicate();
}

