package ru.yandex.logbroker2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class FieldConfigBuilder
     extends AbstractFieldConfigBuilder<FieldConfigBuilder>
{
    public FieldConfigBuilder() {
        this(FieldConfigDefaults.INSTANCE);
    }

    public FieldConfigBuilder(final FieldConfig config) {
        super(config);
    }

    public FieldConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, FieldConfigDefaults.INSTANCE);
    }

    public FieldConfigBuilder(
        final IniConfig config,
        final FieldConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public FieldConfigBuilder self() {
        return this;
    }

    public ImmutableFieldConfig build() throws ConfigException {
        return new ImmutableFieldConfig(this);
    }
}
