package ru.yandex.logbroker2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class GrpcHostConfigBuilder
     extends AbstractGrpcHostConfigBuilder<GrpcHostConfigBuilder>
{
    public GrpcHostConfigBuilder() {
        this(GrpcHostConfigDefaults.INSTANCE);
    }

    public GrpcHostConfigBuilder(final GrpcHostConfig config) {
        super(config);
    }

    public GrpcHostConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, GrpcHostConfigDefaults.INSTANCE);
    }

    public GrpcHostConfigBuilder(
        final IniConfig config,
        final GrpcHostConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableGrpcHostConfig build() throws ConfigException {
        return new ImmutableGrpcHostConfig(
            this);
    }

    @Override
    protected GrpcHostConfigBuilder self() {
        return this;
    }
}
