package ru.yandex.logbroker2.config;

import java.util.concurrent.TimeUnit;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ClientHttpsConfig;
import ru.yandex.http.config.ClientHttpsConfigDefaults;
import ru.yandex.http.config.RetriesConfig;
import ru.yandex.http.config.RetriesConfigDefaults;

public class GrpcHostConfigDefaults
     implements GrpcHostConfig
{
    public static final GrpcHostConfigDefaults INSTANCE =
        new GrpcHostConfigDefaults();

    protected GrpcHostConfigDefaults() {
    }

    @Override
    public HttpHost host() {
        return null;
    }

    @Override
    public ClientHttpsConfig https() {
        return ClientHttpsConfigDefaults.INSTANCE;
    }

    @Override
    public RetriesConfig retries() {
        return RetriesConfigDefaults.INSTANCE;
    }

    @Override
    public String userAgent() {
        return "abc:pssearch";
    }

    @Override
    public long keepAliveTimeout() {
        return TimeUnit.SECONDS.toMillis(1);
    }

    @Override
    public long keepAliveTime() {
        return TimeUnit.SECONDS.toMillis(10);
    }

    @Override
    public boolean keepAliveWithoutCalls() {
        return true;
    }
}
