package ru.yandex.logbroker2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IamJwtConfigBuilder
     extends AbstractIamJwtConfigBuilder<IamJwtConfigBuilder>
{
    public IamJwtConfigBuilder() {
        this(IamJwtConfigDefaults.INSTANCE);
    }

    public IamJwtConfigBuilder(final IamJwtConfig config) {
        super(config);
    }

    public IamJwtConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, IamJwtConfigDefaults.INSTANCE);
    }

    public IamJwtConfigBuilder(
        final IniConfig config,
        final IamJwtConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableIamJwtConfig build() throws ConfigException {
        return new ImmutableIamJwtConfig(
            this);
    }

    @Override
    protected IamJwtConfigBuilder self() {
        return this;
    }
}
