package ru.yandex.logbroker2.config;

import ru.yandex.logbroker2.FieldDuplicationPolicy;
import ru.yandex.logbroker2.FieldPresencePolicy;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableFieldConfig implements FieldConfig, ImmutableConfig {
    private final String selector;
    private final FieldPresencePolicy presence;
    private final String headerName;
    private final String cgiParameter;
    private final FieldDuplicationPolicy onDuplicate;

    public ImmutableFieldConfig(final FieldConfig config)
        throws ConfigException
    {
        selector = SELECTOR.validate(config.selector());
        presence = PRESENCE.validate(config.presence());
        headerName = HEADER_NAME.validate(config.headerName());
        cgiParameter = CGI_PARAMETER.validate(config.cgiParameter());
        onDuplicate = ON_DUPLICATE.validate(config.onDuplicate());
    }

    @Override
    public String selector() {
        return selector;
    }

    @Override
    public FieldPresencePolicy presence() {
        return presence;
    }

    @Override
    public String headerName() {
        return headerName;
    }

    @Override
    public String cgiParameter() {
        return cgiParameter;
    }

    @Override
    public FieldDuplicationPolicy onDuplicate() {
        return onDuplicate;
    }
}

