package ru.yandex.logbroker2.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableClientHttpsConfig;
import ru.yandex.http.config.ImmutableRetriesConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableGrpcHostConfig
     implements GrpcHostConfig
{
    private final HttpHost host;
    private final ImmutableClientHttpsConfig https;
    private final ImmutableRetriesConfig retries;
    private final String userAgent;
    private final long keepAliveTimeout;
    private final long keepAliveTime;
    private final boolean keepAliveWithoutCalls;

    public ImmutableGrpcHostConfig(
        final GrpcHostConfig config)
        throws ConfigException
    {
        this.host = config.host();
        this.https = new ImmutableClientHttpsConfig(
            config.https());
        this.retries = new ImmutableRetriesConfig(
            config.retries());
        this.userAgent = config.userAgent();
        this.keepAliveTimeout = config.keepAliveTimeout();
        this.keepAliveTime = config.keepAliveTime();
        this.keepAliveWithoutCalls = config.keepAliveWithoutCalls();
    }

    @Override
    public HttpHost host() {
        return host;
    }

    @Override
    public ImmutableClientHttpsConfig https() {
        return https;
    }

    @Override
    public ImmutableRetriesConfig retries() {
        return retries;
    }

    @Override
    public String userAgent() {
        return userAgent;
    }

    @Override
    public long keepAliveTimeout() {
        return keepAliveTimeout;
    }

    @Override
    public long keepAliveTime() {
        return keepAliveTime;
    }

    @Override
    public boolean keepAliveWithoutCalls() {
        return keepAliveWithoutCalls;
    }
}
