package ru.yandex.logbroker2.config;

import java.security.PrivateKey;

import ru.yandex.parser.config.ConfigException;

public class ImmutableIamJwtConfig
     extends ImmutableGrpcHostConfig
     implements IamJwtConfig
{
    private final PrivateKey privateKey;
    private final String serviceAccountId;
    private final String keyId;
    private final String database;
    private final String endpoint;
    private final String audience;

    public ImmutableIamJwtConfig(
        final IamJwtConfig config)
        throws ConfigException
    {
        super(config);
        this.privateKey = config.privateKey();
        this.serviceAccountId = config.serviceAccountId();
        this.keyId = config.keyId();
        this.endpoint = config.discoveryEndpoint();
        this.database = config.database();
        this.audience = config.audience();
    }

    @Override
    public PrivateKey privateKey() {
        return privateKey;
    }

    @Override
    public String serviceAccountId() {
        return serviceAccountId;
    }

    @Override
    public String keyId() {
        return keyId;
    }

    @Override
    public String discoveryEndpoint() {
        return endpoint;
    }

    @Override
    public String database() {
        return database;
    }

    @Override
    public String audience() {
        return audience;
    }
}
