package ru.yandex.logbroker2.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableLogbroker2ConsumerConfig
    extends ImmutableHttpProxyConfig
    implements Logbroker2ConsumerConfig
{
    private final Map<String, ImmutableLogbroker2SingleConsumerConfig> consumers;

    public ImmutableLogbroker2ConsumerConfig(
        final Logbroker2ConsumerConfig config)
        throws ConfigException
    {
        super(config);
        Map<String, ? extends Logbroker2SingleConsumerConfig> consumers =
            config.consumers();
        int size = consumers.size();
        if (size == 0) {
            throw new ConfigException("No consumers configured");
        } else if (size == 1) {
            Map.Entry<String, ? extends Logbroker2SingleConsumerConfig> entry =
                consumers.entrySet().iterator().next();
            this.consumers = Collections.singletonMap(
                entry.getKey(),
                new ImmutableLogbroker2SingleConsumerConfig(entry.getValue()));
        } else {
            this.consumers = new LinkedHashMap<>(size << 1);
            for (Map.Entry<String, ? extends Logbroker2SingleConsumerConfig>
                entry: consumers.entrySet())
            {
                this.consumers.put(
                    entry.getKey(),
                    new ImmutableLogbroker2SingleConsumerConfig(
                        entry.getValue()));
            }
        }
        for (ImmutableLogbroker2SingleConsumerConfig consumer
            : this.consumers.values())
        {
            if (consumer.tvmClientId() != null) {
                forceTvm2ServiceConfig();
            }
        }
    }

    @Override
    public Map<String, ImmutableLogbroker2SingleConsumerConfig> consumers() {
        return consumers;
    }
}

