package ru.yandex.logbroker2.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class Logbroker2ConsumerConfigBuilder
    extends AbstractLogbroker2ConsumerConfigBuilder<
        Logbroker2ConsumerConfigBuilder>
{
    public Logbroker2ConsumerConfigBuilder() {
        super(Logbroker2ConsumerConfigDefaults.INSTANCE);
    }

    public Logbroker2ConsumerConfigBuilder(
        final Logbroker2ConsumerConfig config)
    {
        super(config);
    }

    public Logbroker2ConsumerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, Logbroker2ConsumerConfigDefaults.INSTANCE);
    }

    public Logbroker2ConsumerConfigBuilder(
        final IniConfig config,
        final Logbroker2ConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public Logbroker2ConsumerConfigBuilder self() {
        return this;
    }

    public ImmutableLogbroker2ConsumerConfig build() throws ConfigException {
        return new ImmutableLogbroker2ConsumerConfig(this);
    }
}

