package ru.yandex.logbroker2.config;

import java.util.Map;
import java.util.Set;

import ru.yandex.http.config.URIConfig;
import ru.yandex.logbroker2.LBDataFormat;

public interface Logbroker2SingleConsumerConfig {
    URIConfig targetConfig();

    Set<String> balancerHosts();

    int balancerPort();

    int proxyPort();

    int prefetchCount();

    long prefetchDataSize();

    int perTopicPrefetchCount();

    long perTopicPrefetchDataSize();

    Map<String, Integer> sendBatchSize();

    Set<String> topics();

    String clientId();

    boolean readOnlyLocal();

    boolean gzipRequests();

    String tvmClientId();

    IamJwtConfig iamConfig();

    LBDataFormat dataFormat();

    Map<String, ? extends FieldConfig> fieldsConfig();
}
